program define table456_dynan

  clear all
  global mydate = subinstr("${S_DATE}"," ","-",.)
  capture log close
  quietly log using logfiles/table456_dynan_`1'_$mydate, replace

  file open myfile using "logfiles/table456_dynan_`1'_$mydate.txt", write replace
  set more off
  file open myfilep using "logfiles/table456_dynan_`1'_pval$mydate.txt", write replace

* this dataset is generated by make_bpea_data.do

  use bpea_data
  sort persid yr

* for test purposes
*  drop if _n > 10000

* create the permutation variables (see run_bpea_dynan for the ones that appeared in the paper):
* 
* 1: OLS regression, based on all households who are in the sample
*    for every wave from 2005-2009
* 2: OLS regression, based on all households who are in the sample
*    for every wave from 2005-2009; changing dependent variable to del(C/Yavg)
* 3: OLS regression, based on all households who are in the sample
*    for every wave from 2005-2009; using ex post debt variables
* 4: OLS regression, based on all households who are in the sample
*    for every wave from 2005-2009, but for 2005-2007
* 5: OLS regression, based on all households who are in the sample
*    for every wave from 2005-2009, but for 2005-2007 & 2007-2009
* 6: OLS regression, based on all households who are in the sample
*    for every wave from 2005-2009, adding interaction with ur
* 7: OLS regression, based on all households who are in the sample
*    for every wave from 2005-2009, adding interaction with del(ur)
* 8: cnsreg regression, based on all households who are in the sample
*    for every wave from 2005-2009; changing dependent variable to del(C/Yavg) and restricting coeff on wealth



  local startyr 2007
  local endyr 2009

  if `1'==4 {
    local startyr 2005
    local endyr 2007
  }

  quietly gen temp1 = (wgt>=0 & wgt~=.)
  quietly gen temp4 = ((temp1 + l2.temp1 + l4.temp1) == 3)
  quietly replace temp4 = 0 if yr ~= 2009
  by persid:  egen cons_samp = max(temp4)
  drop temp*

  quietly gen temp1 = reth
  quietly replace temp1 = 0 if yr~=`endyr' | temp1==.
  by persid:  egen retsamp = max(temp1)
  drop temp1

  quietly gen temp1 = hboom6
  quietly replace temp1 = 0 if hboom6==. 
  by persid:  egen boomsamp = max(temp1)
  drop temp1

  quietly gen temp1 = homeown
  quietly replace temp1 = 0 if yr~=`startyr' | temp1==.
  by persid:  egen hosamp = max(temp1)
  drop temp1 

  quietly gen mort_fc_yes  = mort_fc_yes_1 == 1 | mort_fc_yes_2 == 1
  quietly gen temp1 = mort_fc_yes
  quietly replace temp1 = 0 if yr~=2009 | temp1==.
  by persid:  egen fcsamp = max(temp1)
  drop temp1 

  quietly gen exit_ho_2 = (homeown==0) & (l2.homeown==1)
  quietly gen temp1 = exit_ho_2
  quietly replace temp1 = 0 if yr~=`endyr' | temp1==.
  by persid:  egen exhosamp = max(temp1)
  drop temp1 

* generate average income

  quietly gen temp1 = 1/3*(myprev + l2.myprev + l4.myprev)
  quietly replace temp1 = 0 if yr~=`endyr' | temp1==.
  by persid:  egen yavg = max(temp1)
  quietly replace temp1 = . if temp1 == 0
  drop temp1

* generate changes

  local vlist d_to_y d_to_a mort_to_hv mort_to_y consxh_to_y networth_to_y nocars mvp_to_y ds_to_y consxh_aa
  local vlist `vlist' consdbt_to_y adds_alts_to_y myprev networth

  foreach ddd in 2 4 {
    foreach vvv in `vlist' {
      quietly gen d`ddd'`vvv' = `vvv' - l`ddd'.`vvv'
    }
  }

* generate ratios of changes to average income

  quietly gen d2consxh_to_yavg = 100*d2consxh_aa / yavg
  quietly gen d2networth_to_yavg = 100*d2networth / yavg
  quietly gen d2myprev_to_yavg = 100*d2myprev / yavg
  
* divide income, consumption, and wealth by 1000

  foreach vvv in myprev consxh_aa networth hsval tot_fin mort_bal veh_bal oth_dbt cons_dbt adds_alts {
     quietly replace `vvv' = `vvv'/1000
  }

* Generate log differences
*
* Actually we are going to use the difference of the inverse hyperbolic sine
* instead because it takes negative values, which otherwise would be a problem
* since we are especially interested in the low-wealth guys.
*
  foreach zzz in 2 4 {
    foreach vvv in consxh_aa myprev hsval tot_fin mort_bal veh_bal_amt oth_dbt networth  {
       quietly gen ihsvar = ln(`vvv' + sqrt(`vvv'^2 + 1))
       quietly gen ld`zzz'`vvv' = 100*(ihsvar - l`zzz'.ihsvar)
       drop ihsvar 
    }
  }

* make mort_to_hvhat; the LTV that the h/o would have if all that changed over the two years was
* house prices.

  quietly gen hsvalhat = l2.hsval*(state_hpi/l2.state_hpi)
  quietly gen mort_to_hvhat = mort_bal_amt/hsvalhat
  quietly replace mort_to_hvhat = 0 if homeown==0
  corr mort_to_hv mort_to_hvhat if yr==`endyr'

* generate average unemployment rates for t and t-2

  quietly gen avg_ur = 1/2*(state_ur + l2.state_ur)

* permutations

  local depvar ld2consxh_aa
  local othvar hage hcoll myprev state_ur d2state_ur ld2myprev ld2networth
  local hatspec 0
  local dropmore *

  if `1' == 1 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local rrr OLS 
     local regcomm regress
  }   

  if `1' == 2 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local rrr OLS 
     local regcomm regress
     local extra Dep var = del(C/Yavg)
     local depvar d2consxh_to_yavg
     local othvar hage hcoll myprev state_ur d2state_ur d2networth_to_yavg d2myprev_to_yavg
     local dropmore replace dropit = 1 if (d2networth_to_yavg > 1000 | d2networth_to_yavg < -1000) & d2networth_to_yavg ~=. 
  }   

 if `1' == 3 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local rrr OLS 
     local regcomm regress
     local extra Using ex post debt variables
     foreach vvv in mort_to_hv mds_to_y {
       quietly replace `vvv' = f2.`vvv'
     }
  }   

 if `1' == 4 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local rrr OLS 
     local regcomm regress
  }   

  if `1' == 5 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local rrr OLS 
     local regcomm regress
     local extra Pooled 05-07 & 07-09
     local extrayr | yr==2007
     quietly gen d2009 = (yr==2009)
     local othvar hage hcoll myprev state_ur d2state_ur ld2myprev ld2networth d2009
  }   

 if `1' == 6 {
     quietly gen insamp = (cons_samp==1)
     local incrowd All households
     local rrr OLS
     local regcomm regress
     local interact_ur yes    
     local extra UR interactions
  }   

 if `1' == 7 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local rrr OLS
     local regcomm regress
     local interact_dur yes    
     local extra del(UR) interactions
  }   

  if `1' == 8 {
     quietly gen insamp = (cons_samp==1) 
     local incrowd All households
     local rrr Constrained linear reg
     local regcomm cnsreg
     local extra Dep var = del(C/Yavg), coef on W=0.05
     local extraextra , constraint(1)
     local depvar d2consxh_to_yavg
     local othvar hage hcoll myprev state_ur d2state_ur d2networth_to_yavg d2myprev_to_yavg
     local dropmore replace dropit = 1 if (d2networth_to_yavg > 1000 | d2networth_to_yavg < -1000) & d2networth_to_yavg ~=. 
     constraint define 1 d2networth_to_yavg = 0.05
  }   

  quietly gen s1 = insamp 
  quietly gen s2 = (insamp==1) & (hosamp==1)
  quietly gen s3 = (insamp==1) & (hosamp==1) & (boomsamp==0)
  quietly gen s4 = (insamp==1) & (hosamp==1) & (boomsamp==1)

  if `1' == 7 {
     quietly replace s3 = (insamp==1) & (boomsamp==0)
     quietly replace s4 = (insamp==1) & (boomsamp==1)
  }   


* labels

  label var hage               "Head age"
  label var hcoll              "Head college degree"
  label var myprev             "Income in t-1"
  label var homeown            "Homeowner"
  label var state_ur           "State UR"
  label var d2state_ur         "del(State UR)"
  label var d2networth_to_y    "del(NW/Y)"
  label var d2networth         "del(W)"
  label var d2networth_to_yavg "del(NW/Yavg)"
  label var ld2networth        "del(IHS NW)"
  label var d2consxh_to_y      "del(C/Y)"
  label var d2consxh_aa        "del(C)"
  label var ld2consxh_aa       "del(IHS C)"
  label var d2myprev           "del(Y)"
  label var ld2myprev          "del(IHS Y)"
  label var d2myprev_to_yavg   "del(Y/Yavg)"

* regressions

local note1 Dependent variable is diff of IHS non housing consumption. 
local note2 HHs with complete set of intvws 2005-2009.
local note3 Regressions drop extreme outliers for M/HV & DSR.

foreach ddd in lev dsr both {

  capture drop drat* 

  if "`ddd'" == "lev" {
     quietly gen drat1 = mort_to_hv
     if "`hatspec'" == "yes" {
        quietly replace drat1 = f2.mort_to_hvhat
     }
     local debtvar drat1
     local regdebtvar1 lag_drat1 
     local regdebtvar2 lag_topdrat1 
     local regdebtvar3 lag_drat1 lag_topdrat1 lag_drat1_topdrat1
     local drat1lab1 "Mort/HV`hhh'"
     local drat1lab2 "Top Quint M/HV`hhh'"
     local drat1lab3 "Mort/HV`hhh' x TopQ"
     if "`interact_dur'" == "yes" {
       local regdebtvar1 lag_drat1 lag_drat1_d2state_ur
       local regdebtvar2 lag_topdrat1 lag_topdrat1_d2state_ur
       local drat1lab4 "M/HV x del(UR)"
       local drat1lab5 "TopQ x del(UR)"
     }
     if "`interact_ur'" == "yes" {
       local regdebtvar1 lag_drat1 lag_drat1_state_ur
       local regdebtvar2 lag_topdrat1 lag_topdrat1_state_ur
       local drat1lab4 "M/HV x UR"
       local drat1lab5 "TopQ x UR"
     }
     local dropthem replace dropit = 1 if lag_drat1 > 2 & lag_drat1 ~=. 
  }

  if "`ddd'" == "dsr" {
     quietly gen drat1 = mds_to_y
     local debtvar drat1
     local regdebtvar1 lag_drat1 
     local regdebtvar2 lag_topdrat1 
     local regdebtvar3 lag_drat1 lag_topdrat1 lag_drat1_topdrat1
     local drat1lab1 "Mort DSR"
     local drat1lab2 "Top Quint DSR"
     local drat1lab3 "Mort DSR x TopQ"
     if "`interact_dur'" == "yes" {
       local regdebtvar1 lag_drat1 lag_drat1_d2state_ur
       local regdebtvar2 lag_topdrat1 lag_topdrat1_d2state_ur
       local drat1lab4 "MDSR x del(UR)"
       local drat1lab5 "TopQ x del(UR)"
     }
     if "`interact_ur'" == "yes" {
       local regdebtvar1 lag_drat1 lag_drat1_state_ur
       local regdebtvar2 lag_topdrat1 lag_topdrat1_state_ur
       local drat1lab4 "MDSR x UR"
       local drat1lab5 "TopQ x UR"
     }          
     local dropthem replace dropit = 1 if lag_drat1 > 10 & lag_drat1 ~=.    
  }

 if "`ddd'" == "both" {
     quietly gen drat1 = mort_to_hv
     if "`hatspec'" == "yes" {
        quietly replace drat1 = f2.mort_to_hvhat
     }
     quietly gen drat2 = mds_to_y
     local debtvar drat1 drat2
     local regdebtvar1 lag_drat1 lag_drat2
     local regdebtvar2 lag_topdrat1 lag_topdrat2
     local regdebtvar3 lag_drat1 lag_topdrat1 lag_drat1_topdrat1 lag_drat2 lag_topdrat2 lag_drat2_topdrat2
     local drat1lab1 "Mort/HV`hhh'"
     local drat1lab2 "Top Quint M/HV`hhh'"
     local drat1lab3 "Mort/HV`hhh' x TopQ"
     local drat2lab1 "Mort DSR"
     local drat2lab2 "Top Quint DSR"
     local drat2lab3 "Mort DSR x TopQ"
     if "`interact_dur'" == "yes" {
       local regdebtvar1 lag_drat1 lag_drat1_d2state_ur lag_drat2 lag_drat2_d2state_ur 
       local regdebtvar2 lag_topdrat1 lag_topdrat1_d2state_ur lag_topdrat2 lag_topdrat2_d2state_ur 
       local drat1lab4 "M/HV x del(UR)"
       local drat1lab5 "TopQ x del(UR)"
       local drat2lab4 "MDSR x del(UR)"
       local drat2lab5 "TopQ x del(UR)"
     }
     if "`interact_ur'" == "yes" {
       local regdebtvar1 lag_drat1 lag_drat1_state_ur lag_drat2 lag_drat2_state_ur 
       local regdebtvar2 lag_topdrat1 lag_topdrat1_state_ur lag_topdrat2 lag_topdrat2_state_ur 
       local drat1lab4 "M/HV x UR"
       local drat1lab5 "TopQ x UR"
       local drat2lab4 "MDSR x UR"
       local drat2lab5 "TopQ x UR"
     }
     local dropthem replace dropit = 1 if (lag_drat1 > 2 & lag_drat1 ~=.) | (lag_drat2 > 10 & lag_drat2 ~=.) 
  }

  foreach sss in s1 s2 s3 s4 {
     capture drop topdrat* lag_drat* lag_top*

     foreach vvv in `debtvar' {

       quietly _pctile `vvv' if yr == `startyr' & `vvv' ~=. & `sss'==1 [w=wgt], percentiles(80)
       quietly gen top`vvv' = (`vvv' >= r(r1)) if yr == `startyr' & `vvv' ~=. & `sss'==1

       if `1'==17 {
         quietly _pctile `vvv' if yr == 2005 & `vvv' ~=. & `sss'==1 [w=wgt], percentiles(80)
         quietly replace top`vvv' = (`vvv' >= r(r1)) if yr == 2005 & `vvv' ~=. & `sss'==1
       }

       quietly gen lag_`vvv' = l2.`vvv'
       quietly gen lag_top`vvv' = l2.top`vvv'
       quietly gen lag_`vvv'_top`vvv' = lag_`vvv'*lag_top`vvv'
       label var lag_`vvv' "``vvv'lab1'"
       label var lag_top`vvv' "``vvv'lab2'"
       label var lag_`vvv'_top`vvv' "``vvv'lab3'"

       if "`interact_dur'" == "yes" {
         quietly gen lag_`vvv'_d2state_ur = lag_`vvv'*d2state_ur
         label var lag_`vvv'_d2state_ur "``vvv'lab4'"
         quietly gen lag_top`vvv'_d2state_ur = lag_top`vvv'*d2state_ur
         label var lag_top`vvv'_d2state_ur "``vvv'lab5'"
       }

       if "`interact_ur'" == "yes" {
         quietly gen lag_`vvv'_state_ur = lag_`vvv'*state_ur
         label var lag_`vvv'_state_ur "``vvv'lab4'"
         quietly gen lag_top`vvv'_state_ur = lag_top`vvv'*state_ur
         label var lag_top`vvv'_state_ur "``vvv'lab5'"
       }          

     }
  
     local s2_title "`1': `incrowd', `startyr'-`endyr', `rrr', Full & H/O Samples, debt var = `drat1lab1', `drat2lab1', `extra'"
     local s4_title "`1': `incrowd', `startyr'-`endyr', `rrr', H/O Non-boom and Boom Samples, debt var = `drat1lab1', `drat2lab1', `extra'"
     capture drop dropit
     quietly gen dropit = 0
     `dropthem' & `sss'==1 & yr==`endyr' 
     `dropmore' & `sss'==1 & yr==`endyr' 

     forvalues nnn = 1/3 {
       quietly eststo:  quietly `regcomm' `depvar' `othvar' ///
           `regdebtvar`nnn'' ///
           if `sss'==1 & (yr==`endyr' `extrayr') & dropit==0 `extraextra'
     }
     if "`sss'" == "s2" {

        esttab using "logfiles/table456_dynan_`1'_$mydate.txt", append /// 
        mtitles("Full 1" "Full 2" "Full 3" "H/O 1" "H/O 2" "H/O 3") ///
        starlevels(* .15 ** .10 *** .05) ///
        label b(3) se(3) ar2 obslast ///
        title(``sss'_title') ///
        addnote("`note1' `note2' `note3'") ///
        compress

        esttab using "logfiles/table456_dynan_`1'_pval$mydate.txt", append /// 
        mtitles("Full 1" "Full 2" "Full 3" "H/O 1" "H/O 2" "H/O 3") ///
        starlevels(* .15 ** .10 *** .05) ///
        label b(3) p(3) ar2 obslast ///
        title(``sss'_title') ///
        addnote("`note1' `note2' `note3'") ///
        compress

        eststo clear  
   }
   if "`sss'" == "s4" {
        esttab using "logfiles/table456_dynan_`1'_$mydate.txt", append /// 
        mtitles("Non-Boom 1" "Non-Boom 2" "Non-Boom 3" "Boom 1" "Boom 2" "Boom 3") ///
        starlevels(* .15 ** .10 *** .05) ///
        label b(3) se(3) se ar2 obslast ///
        title(``sss'_title') ///
        addnote("`note1' `note2' `note3'") ///
        compress

        esttab using "logfiles/table456_dynan_`1'_pval$mydate.txt", append /// 
        mtitles("Non-Boom 1" "Non-Boom 2" "Non-Boom 3" "Boom 1" "Boom 2" "Boom 3") ///
        starlevels(* .15 ** .10 *** .05) ///
        label b(3) se(3) se ar2 obslast ///
        title(``sss'_title') ///
        addnote("`note1' `note2' `note3'") ///
        compress

        eststo clear  
   }
 }
}
capture log close

end
